//****************************************************************************
//  x10.c
//  X10 PSC05 PowerLine Interface Demo for Arduino Uno.
//  Allows the user to Turn ON and OFF X10 Devices.
//  No Dimming Functions are provided with this sofware.
//  All X10 Channels are supported.
//  by RCI
//
//  Requires X10.cpp and X10.h Library Files

//****************************************************************************
#include <arduino.h>
//**************************************************************************
#include <sLCD.h>        // 2 Wire LCD Driver for 74174 see 
#include <stdlib.h>
#include <X10.h>         // X10 Library,  See X10.cpp and X10.h
//****************************************************************************
sLCD sLCD(8, 9);  // Sets up Clk, Data Pins
X10 X10(10, 11, 12);  
#define ON 20
#define OFF 28

//*** Variable Declarations***************************************************
//                           1234567890123456
const char Message1[17]   = "x10 Demo Program";
const char Message2[17]   = "P16F688  By RCI ";
const char Message99[17]  = "                ";
const char ButtonPin1 = 6;
const char ButtonPin2 = 7;
unsigned char txt[4];
unsigned char house_codes, unit_codes;
unsigned char count;
unsigned char Button1, Button2;
unsigned int tmp;
//****************************************************************************
void setup()
{
//****************************************************************************
// Initialize Serial LCD Display
//****************************************************************************    
  sLCD.Init_Display();
  sLCD.sResetLCD();           // Clears Display
  pinMode(10, INPUT);         // ZC output to PSC05
  pinMode(11, OUTPUT);        // Trans Data to PSC05
  pinMode(12, INPUT);         // Rcv Data from PSC05
  pinMode(ButtonPin1, INPUT);      // sets the digital pin 6 as input
  pinMode(ButtonPin2, INPUT);      // sets the digital pin 7 as input  
  sLCD.sLCD_Out(1, 1, Message1);
  sLCD.sLCD_Out(2, 1, Message2);
  delay(2000);
  sLCD.sLCD_Out(2, 1, Message99);
  count = 0;
}
//************************************************************************
void loop() 
{
 
    Button1 = digitalRead(ButtonPin1);
    Button2 = digitalRead(ButtonPin2);
    
  if(Button1 == 0)
    {
    sLCD.sLCD_Out(1, 1, "X10 Transmit ON ");
    sLCD.sLCD_Out(2, 1, Message99);
    X10.X10Trans('A', 10, ON);           // House codes A - P,  Channels 0 - 15
    sLCD.sLCD_Out(2, 1, Message99);
    }
  if(Button2 == 0)
    {
    sLCD.sLCD_Out(1, 1, "X10 Transmit OFF");
    sLCD.sLCD_Out(2, 1, Message99);
    X10.X10Trans('A', 10, OFF);          // House codes A - P,  Channels 0 - 15
    sLCD.sLCD_Out(2, 1, Message99);
    }
//***** x10 Read Routine ********************************************************
      if(X10.X10_data_ready())
        {
        house_codes = X10.X10_read_first();             // Read Pulses from PSC05
        unit_codes = X10.X10_read_second();
        if (unit_codes < 19)                            // If valid Chan Number
           {
           tmp = unit_codes;
           }      
        if (unit_codes == 20) 
           {
           sLCD.sLCD_Chr(2, 1, house_codes);            // Display House Code
           sLCD.sMove_Cursor(2, 3); 
           sLCD.sLCDtoBCD(tmp, 3); 
           sLCD.sLCD_Out(2, 8, "ON ");                  // Display ON
           }
        if (unit_codes == 28) 
           {
           sLCD.sLCD_Chr(2, 1, house_codes);            // Display House Code
           sLCD.sMove_Cursor(2, 3); 
           sLCD.sLCDtoBCD(tmp, 3);               
           sLCD.sLCD_Out(2, 8, "OFF");                  // Display OFF
           }
        }


  
} // End Loop
//****************************************************************************
//****************************************************************************

